/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BehaviorRetained;
import javax.media.j3d.WakeupOnElapsedTime;

class WakeupOnElapsedTimeHeap
implements Cloneable {
    WakeupOnElapsedTime[] data;
    int size = 0;

    WakeupOnElapsedTimeHeap(int n2) {
        this.data = new WakeupOnElapsedTime[n2 + 1];
    }

    WakeupOnElapsedTimeHeap() {
        this(10);
    }

    final int size() {
        return this.size;
    }

    final boolean isEmpty() {
        return this.size == 0;
    }

    final WakeupOnElapsedTime getMin() {
        return this.data[1];
    }

    final void insert(WakeupOnElapsedTime wakeupOnElapsedTime) {
        if (this.data.length == this.size + 1) {
            WakeupOnElapsedTime[] wakeupOnElapsedTimeArray = this.data;
            this.data = new WakeupOnElapsedTime[wakeupOnElapsedTimeArray.length << 1];
            System.arraycopy(wakeupOnElapsedTimeArray, 0, this.data, 0, wakeupOnElapsedTimeArray.length);
        }
        int n2 = ++this.size;
        int n3 = n2 >> 1;
        WakeupOnElapsedTime wakeupOnElapsedTime2 = this.data[n3];
        long l2 = wakeupOnElapsedTime.triggeredTime;
        while (n2 > 1 && wakeupOnElapsedTime2.triggeredTime > l2) {
            this.data[n2] = wakeupOnElapsedTime2;
            n2 = n3;
            wakeupOnElapsedTime2 = this.data[n3 >>= 1];
        }
        this.data[n2] = wakeupOnElapsedTime;
    }

    final void extract(BehaviorRetained behaviorRetained) {
        for (int i2 = 1; i2 <= this.size; ++i2) {
            if (this.data[i2].behav != behaviorRetained) continue;
            this.extract(i2);
        }
    }

    final boolean extract(WakeupOnElapsedTime wakeupOnElapsedTime) {
        for (int i2 = 1; i2 <= this.size; ++i2) {
            if (this.data[i2] != wakeupOnElapsedTime) continue;
            this.extract(i2);
            return true;
        }
        return false;
    }

    final WakeupOnElapsedTime extractMin() {
        return this.extract(1);
    }

    final WakeupOnElapsedTime extract(int n2) {
        WakeupOnElapsedTime wakeupOnElapsedTime = this.data[n2];
        this.data[n2] = this.data[this.size];
        this.data[this.size] = null;
        --this.size;
        while (true) {
            int n3 = n2 << 1;
            int n4 = n3 + 1;
            int n5 = n3 <= this.size && this.data[n3].triggeredTime < this.data[n2].triggeredTime ? n3 : n2;
            if (n4 <= this.size && this.data[n4].triggeredTime < this.data[n5].triggeredTime) {
                n5 = n4;
            }
            if (n5 == n2) break;
            WakeupOnElapsedTime wakeupOnElapsedTime2 = this.data[n5];
            this.data[n5] = this.data[n2];
            this.data[n2] = wakeupOnElapsedTime2;
            n2 = n5;
        }
        return wakeupOnElapsedTime;
    }

    final void trimToSize() {
        if (this.data.length > this.size + 1) {
            WakeupOnElapsedTime[] wakeupOnElapsedTimeArray = this.data;
            this.data = new WakeupOnElapsedTime[this.size + 1];
            System.arraycopy(wakeupOnElapsedTimeArray, 0, this.data, 0, this.data.length);
        }
    }

    protected final Object clone() {
        try {
            WakeupOnElapsedTimeHeap wakeupOnElapsedTimeHeap = (WakeupOnElapsedTimeHeap)super.clone();
            wakeupOnElapsedTimeHeap.data = new WakeupOnElapsedTime[this.size + 1];
            System.arraycopy(this.data, 0, wakeupOnElapsedTimeHeap.data, 0, this.size + 1);
            return wakeupOnElapsedTimeHeap;
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new InternalError();
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("[ ");
        if (this.size > 0) {
            stringBuffer.append(this.data[1]);
        }
        for (int i2 = 2; i2 <= this.size; ++i2) {
            stringBuffer.append("," + this.data[i2]);
        }
        stringBuffer.append(" ]");
        return stringBuffer.toString();
    }
}

